#pragma semicolon 1

#include <sourcemod>
#include <sdktools>

#define NOBLOCK_RADIUS	75.0
#define PL_VERSION	"1.1"

public Plugin:myinfo =
{
	name        = "Team Only Noblock",
	author      = "TigerOx",
	description = "Prevents collisions with teammates.",
	version     = PL_VERSION,
	url         = ""
}

new g_Team[MAXPLAYERS+1];
new g_OldblockStatus[MAXPLAYERS+1];

public OnPluginStart()
{
	CreateConVar("sm_team_noblock", PL_VERSION, "Team Only Noblock", FCVAR_DONTRECORD|FCVAR_NOTIFY|FCVAR_PLUGIN|FCVAR_REPLICATED|FCVAR_SPONLY);
	HookEvent("player_team", OnPlayerTeam);
}

public Action:OnPlayerTeam(Handle:event,const String:name[],bool:dontBroadcast)
{	
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	if(client) g_Team[client] = GetEventInt(event,"team");
}

public OnGameFrame()
{
	decl client, i;
	decl Float:tempOrigin[3], Float:clientOrigin[3];
	decl blockStatus[MAXPLAYERS+1];
	
	for(client = 1; client <= MaxClients; client++)
	{
		blockStatus[client] = 0;
		
		if(!IsClientInGame(client) || !IsPlayerAlive(client))
		{
			g_OldblockStatus[client] = 0;
			continue;
		}
		//Set to block
		blockStatus[client] = 5;
	}
	
	for(client = 1; client <= MaxClients; client++)
	{
		if(!blockStatus[client])
			continue;
		
		//Get player location
		GetEntPropVector(client, Prop_Send, "m_vecOrigin", clientOrigin);
		
		//Check for imminent collisions.with other players
		for(i = 1; i <= MaxClients; i++)
		{
			if((i == client) || !blockStatus[i] || (g_Team[i] != g_Team[client]))
				continue;
			
			//Get other players location
			GetEntPropVector(i, Prop_Send, "m_vecOrigin", tempOrigin);
			
			if(GetVectorDistance(tempOrigin, clientOrigin) <= NOBLOCK_RADIUS)
			{
				//There is a team collision, unblock.
				blockStatus[client] = 2;
				break;
			}
		}
		//Set Noblock on/off
		//Try to reduce collisiongroup changes. It might help
		//with bouncing props bug.
		if(blockStatus[client] != g_OldblockStatus[client])
		{
			g_OldblockStatus[client] = blockStatus[client];
			SetEntProp(client, Prop_Send, "m_CollisionGroup", blockStatus[client]);
		}
	}
}

